package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Coyot_chassis extends Coyot_models
{
	public Coyot_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Coyot";
		name = getName();
		
		rID_blueprint = cars.cat_01.Coyot:0x0183r;
		defColorIndex = GameLogic.CARCOLOR_WHITE;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;
		
		value = 3290;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.309;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[4];
		parts_shop_sml[0] = cars.cat_01.Coyot:0x1102r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_01.Coyot:0x1105r; //Right taillight dark
		parts_shop_sml[2] = cars.cat_01.Coyot:0x01FEr; //Left blinker dark
		parts_shop_sml[3] = cars.cat_01.Coyot:0x1106r; //Right blinker dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_01.Coyot:0x010Cr; //Left exhaust
		parts_shop_big[1] = cars.cat_01.Coyot:0x010Br; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		float part_random;

		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.coyot:0x000000E1r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000E2r, "FL door", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000E3r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000E5r, "FR door", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000E6r, "FR seat", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000EBr, "L headlights", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000F1r, "RR door", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000F3r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000F6r, "R seats", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x000000F7r, "RL door", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x00000102r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x00000103r, "trunk", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x00000104r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x00000105r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x0000010Cr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E1r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E2r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E3r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E5r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E6r, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000EBr, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F1r, "RR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F3r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F6r, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F7r, "RL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x00000102r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x00000103r, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x00000104r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x00000105r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x0000010Cr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000FBr, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000FFr, "F bumper", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.coyot:0x0000010Dr, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.coyot:0x000000DEr, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000EFr, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.coyot:0x000000F8r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.coyot:0x0000010Er, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x0000010Fr, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.coyot:0x000000FAr, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.coyot:0x000000FBr, "R bumper", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000F9r, "R bumper 2", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.coyot:0x00000100r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.coyot:0x00000101r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000FFr, "F bumper", actcolor, optical, power );
		}

		addPart( cars.cat_01.coyot:0x00000107r, "FR suspension" );
		addPart( cars.cat_01.coyot:0x00000108r, "RR suspension" );
		addPart( cars.cat_01.coyot:0x00000109r, "RL suspension" );
		addPart( cars.cat_01.coyot:0x0000010Ar, "FL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );

		} else
		{
			if ( random() > 0.5 ) //Spider
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) //Sparkler
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
				}
			} else //Flat
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
				}
			}
		}

		if ( power >= 1.5 )
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 )
		{
/*			if ( optical >= 1.5 )
			{
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
			} else*/
			{
				addPart( parts.running_gear:0x0000020Br, "spring" );
				addPart( parts.running_gear:0x0000020Br, "spring" );
				addPart( parts.running_gear:0x0000020Cr, "spring" );
				addPart( parts.running_gear:0x0000020Cr, "spring" );
			}
		} else
		{
			addPart( parts.running_gear:0x00000215r, "spring" );
			addPart( parts.running_gear:0x00000215r, "spring" );
			addPart( parts.running_gear:0x00000216r, "spring" );
			addPart( parts.running_gear:0x00000216r, "spring" );
		}

		if ( power >= 1.3 )
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.6 )
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.666 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.666)/0.333*2 ); else
		if ( power >= 1.333 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1.333)/0.333*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (power-1)/0.333*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (1-power)/0.5*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000E8r, "hood", actcolor, optical, power );
		} else
		{
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_01.coyot:0x000000EAr, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_01.coyot:0x000000E9r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000E8r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_01.Coyot:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,1,0.5); //2WD all becomes AWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}